varying vec2 TexCoord0;
uniform sampler2D tex;
uniform vec2 texSize;
uniform float intensity;

const float BRIGHTNESS_BOOST = 1.25;

// Will return a value of 1 if the 'v.xy' is < 'value'
float Less(vec2 v, float value)
{
	vec2 temp = 1.0 - step(value, v);
	return temp.x + temp.y;
}

// Will return a value of 1 if the 'v.xy' is >= 'lower' && < 'upper'
float Between(vec2 v, float  lower, float upper)
{
	vec2 temp = step(lower, v) * (1.0 - step(upper, v));
	return temp.x + temp.y;
}

// Will return a value of 1 if 'v.xy' is >= value
float GEqual(vec2 v, float value)
{
	vec2 temp = step(value, v);
	return temp.x + temp.y;
}

void main()
{
	// Minimal intensity - 1 pixel crt channel width
	// Maximal intensity - 5 pixel crt channel width
	float k = 1.0 + 4.0 * intensity;

	vec2 pixelSize = 1.0 / texSize;
	vec4 color = texture2D(tex, TexCoord0);

	// Separate RGB channels along x axis for every single crt cell
	vec2 uvStep = mod(TexCoord0 / pixelSize, 3.0 * k);
	color.rgb *= step(1.0, vec3(
		Less(uvStep, 1.0 * k),
		Between(uvStep, 1.0 * k, 2.0 * k),
		GEqual(uvStep, 2.0 * k)));

	// Due to channel separation we loss some brightness from dropped parts of color
	gl_FragColor = vec4(color.rgb * BRIGHTNESS_BOOST, color.a);
}
